import pandas as pd   
import pickle

   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv") 
  
# Descriptive statistics for age   

age_mean = credit_customers['age'].mean()   

age_median = credit_customers['age'].median()   

age_mode = credit_customers['age'].mode()[0]   

age_range = credit_customers['age'].max() - credit_customers['age'].min()
  
print(f"Age - Mean: {age_mean}, Median: {age_median}, Mode: {age_mode}, Range: {age_range}")  
pickle.dump(age_mean, open("./ref_result/age_mean.pkl","wb"))
pickle.dump(age_median, open("./ref_result/age_median.pkl","wb"))
pickle.dump(age_mode, open("./ref_result/age_mode.pkl","wb"))
pickle.dump(age_range, open("./ref_result/age_range.pkl","wb"))

  